/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CompressionManager {
    private static Object2IntOpenHashMap<String> fuelMap = new Object2IntOpenHashMap();
    public static int DEFAULT_ENERGY = 100000;

    public static Set<String> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static boolean isValidFuel(FluidStack stack) {
        return stack != null && fuelMap.containsKey((Object)stack.getFluid().getName());
    }

    public static int getFuelEnergy(FluidStack stack) {
        return stack == null ? 0 : fuelMap.getInt((Object)stack.getFluid().getName());
    }

    public static int getFuelEnergy100mB(FluidStack stack) {
        return stack == null ? 0 : fuelMap.getInt((Object)stack.getFluid().getName()) / 10;
    }

    public static void refresh() {
    }

    public static boolean addFuel(String fluidName, int energy) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName) || energy < 10000 || energy > 200000000) {
            return false;
        }
        if (fuelMap.containsKey((Object)fluidName)) {
            return false;
        }
        fuelMap.put((Object)fluidName, energy);
        return true;
    }

    public static boolean removeFuel(String fluidName) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName)) {
            return false;
        }
        fuelMap.removeInt((Object)fluidName);
        return true;
    }
}

